/*
 * Decompiled with CFR 0.152.
 */
package net.endil.farmersutils.common.block.entity;

import javax.annotation.Nullable;
import net.endil.farmersutils.common.registry.FUBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;

public class TrayBlockEntity
extends BlockEntity {
    private static final int INVENTORY_SLOT_COUNT = 4;
    private final ItemStackHandler inventory = this.createHandler();

    public TrayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FUBlockEntityTypes.TRAY.get(), pPos, pBlockState);
    }

    public static void displayTick(Level level, BlockPos pos, BlockState state, TrayBlockEntity rack) {
        rack.added();
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, TrayBlockEntity tray) {
    }

    private void added() {
        if (this.f_58857_ == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack trayStack = this.inventory.getStackInSlot(i);
            if (trayStack.m_41619_()) continue;
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
    }

    public void m_183515_(CompoundTag compound) {
        this.writeItems(compound);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).m_41619_()) {
            this.inventory.setStackInSlot(slot, itemStackIn.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getTrayItemOffset(int index) {
        float X_OFFSET = 0.2f;
        float Y_OFFSET = 0.2f;
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.2f, 0.2f), new Vec2(-0.2f, 0.2f), new Vec2(0.2f, -0.2f), new Vec2(-0.2f, -0.2f)};
        return OFFSETS[index];
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

